/* Copyright (C) 2003 International Business Machines
   Corporation and others.  All Rights Reserved. */

/* This example shows the use of the "C" interface */

#include "Clp_C_Interface.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <values.h>

#define isFree       0x00
#define basic        0x01
#define atUpperBound 0x02
#define atLowerBound 0x03
#define superBasic   0x04
#define isFixed      0x05

main ()
{
  /* Get default model */
  Clp_Simplex  * model = Clp_newModel();
  int status;
  const double *rowactive;
  int start[4], index[4];
  int hs[3];
  int which[3];
  double x[3];
  double value[4], collb[3], colub[3];
  double obj[3], rowlb[2], rowub[2];

  start[0] = 0; start[1] = 2; start[2] = 3; start[3] = 4;
  index[0] = 0; index[1] = 1; index[2] = 1; index[3] = 0;
  value[0] = 1; value[1] = 1; value[2] = 1; value[3] = 1;
  collb[0] = -4; collb[1] = -4; collb[2] = -4;
  colub[0] =  4; colub[1] =  4; colub[2] =  4;
  obj[0] = 1; obj[1] = 2; obj[2] = -3;
  rowlb[0] = 1; rowub[0] = 1;
  rowlb[1] = 0; rowub[1] = DBL_MAX;
  which[0] = 0; which[1] = 1; which[2] = 2;
  printf("load problem...\n");
  Clp_loadProblem(model, 3, 2,
		  start, index, value, collb, colub,
		  obj, rowlb, rowub);
  status = 0;
  printf("finished loading...\n");
#if 0
  Clp_loadProblem(Clp_Simplex * model,  const int numcols, const int numrows,
		  const CoinBigIndex * start, const int* index,
		  const double* value,
		  const double* collb, const double* colub,   
		  const double* obj,
		  const double* rowlb, const double* rowub);
#endif

  Clp_setLogLevel(model, 1);

  //Clp_initialDualSolve(model);
  //Clp_initialPrimalSolve(model);
  Clp_dual(model,0);

  printf("iters  = %d\n",Clp_getIterationCount(model));

  {
    /*
      Now to print out solution.  The methods used return modifiable
      arrays while the alternative names return const pointers -
      which is of course much more virtuous.
      
      This version just does non-zero columns
      
    */
    
    /* Columns */
    
    int numberColumns = Clp_numberColumns(model);
    int iColumn;
       
    /* Alternatively getColSolution(model) */
    double * columnPrimal = Clp_primalColumnSolution(model);
    /* Alternatively getReducedCost(model) */
    double * columnDual = Clp_dualColumnSolution(model);
    /* Alternatively getColLower(model) */
    double * columnLower = Clp_columnLower(model);
    /* Alternatively getColUpper(model) */
    double * columnUpper = Clp_columnUpper(model);
    /* Alternatively getObjCoefficients(model) */
    double * columnObjective = Clp_objective(model);
    
    printf("--------------------------------------\n");
    
    printf("  VarInd      Primal          Dual         Lower         Upper          Cost    hs\n");
    
    for (iColumn=0;iColumn<numberColumns;iColumn++) {
      double value;
      value = columnPrimal[iColumn];
      //if (value>1.0e-8||value<-1.0e-8) {
	printf("%6d",iColumn);
	printf(" %13g",columnPrimal[iColumn]);
	printf(" %13g",columnDual[iColumn]);
	printf(" %13g",columnLower[iColumn]);
	printf(" %13g",columnUpper[iColumn]);
	printf(" %13g",columnObjective[iColumn]);
	printf("%6d",Clp_getColumnStatus(model,iColumn));
	printf("\n");
	//}
    }
    printf("--------------------------------------\n");
  }

  printf("Resolve ... \n");
  /** determine variable basis info 
      0 - isFree
      1 - basic
      2 - atUpperBound
      3 - atLowerBound
      4 - superBasic
      5 - isFixed
  */
  //colub[0] = 5;
  //colub[2] = 5;
  //Clp_chgColumnUpper(model, colub);
  //collb[0] = -2;
  //Clp_chgColumnLower(model, collb);
  //obj[1] =  3;
  //Clp_chgObjCoefficients(model, obj);
#if 1
  value[3] = 2;
  Clp_chgMatrix(model, 3, 2,
		start, index, value); 
#endif
#if 0
  /* Delete and put back in columns */
  Clp_deleteColumns(model, 3, which);
  Clp_addColumns(model, 3, collb, colub, obj,
		 start, index, value);
  rowlb[0] = 0; rowub[0] = 0;
  Clp_chgRowLower(model, rowlb);
  Clp_chgRowUpper(model, rowub);
#endif
#if 0
  /* Reload problem */
  Clp_loadProblem(model, 3, 2,
		  start, index, value, collb, colub,
		  obj, rowlb, rowub);
#endif
  Clp_dual(model,0);

  {
    /*
      Now to print out solution.  The methods used return modifiable
      arrays while the alternative names return const pointers -
      which is of course much more virtuous.
      
      This version just does non-zero columns
      
    */
    
    /* Columns */
    
    int numberColumns = Clp_numberColumns(model);
    int iColumn;
    
    
    /* Alternatively getColSolution(model) */
    double * columnPrimal = Clp_primalColumnSolution(model);
    /* Alternatively getReducedCost(model) */
    double * columnDual = Clp_dualColumnSolution(model);
    /* Alternatively getColLower(model) */
    double * columnLower = Clp_columnLower(model);
    /* Alternatively getColUpper(model) */
    double * columnUpper = Clp_columnUpper(model);
    /* Alternatively getObjCoefficients(model) */
    double * columnObjective = Clp_objective(model);
    
    printf("--------------------------------------\n");
    
    printf("  VarInd      Primal          Dual         Lower         Upper          Cost    hs\n");
    
    for (iColumn=0;iColumn<numberColumns;iColumn++) {
      double value;
      value = columnPrimal[iColumn];
      //if (value>1.0e-8||value<-1.0e-8) {
	printf("%6d",iColumn);
	printf(" %13g",columnPrimal[iColumn]);
	printf(" %13g",columnDual[iColumn]);
	printf(" %13g",columnLower[iColumn]);
	printf(" %13g",columnUpper[iColumn]);
	printf(" %13g",columnObjective[iColumn]);
	printf("%6d",Clp_getColumnStatus(model,iColumn));
	printf("\n");
	//}
    }
    printf("--------------------------------------\n");
  }  

  //printf("iters  = %d\n",Clp_numberIterations(model));
  printf("iters  = %d\n",Clp_getIterationCount(model));

  Clp_deleteModel(model);
 
  return 0;
}
